/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.entity.event.v1;

import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_3222;

public final class ServerPlayerEvents {
    public static final Event<CopyFrom> COPY_FROM = EventFactory.createArrayBacked(CopyFrom.class, callbacks -> (oldPlayer, newPlayer, alive) -> {
        for (CopyFrom callback : callbacks) {
            callback.copyFromPlayer(oldPlayer, newPlayer, alive);
        }
    });
    public static final Event<AfterRespawn> AFTER_RESPAWN = EventFactory.createArrayBacked(AfterRespawn.class, callbacks -> (oldPlayer, newPlayer, alive) -> {
        for (AfterRespawn callback : callbacks) {
            callback.afterRespawn(oldPlayer, newPlayer, alive);
        }
    });
    @Deprecated
    public static final Event<AllowDeath> ALLOW_DEATH = EventFactory.createArrayBacked(AllowDeath.class, callbacks -> (player, damageSource, damageAmount) -> {
        for (AllowDeath callback : callbacks) {
            if (callback.allowDeath(player, damageSource, damageAmount)) continue;
            return false;
        }
        return true;
    });

    private ServerPlayerEvents() {
    }

    static {
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                return ((AllowDeath)ALLOW_DEATH.invoker()).allowDeath(player, damageSource, damageAmount);
            }
            return true;
        });
    }

    @Deprecated
    @FunctionalInterface
    public static interface AllowDeath {
        public boolean allowDeath(class_3222 var1, class_1282 var2, float var3);
    }

    @FunctionalInterface
    public static interface AfterRespawn {
        public void afterRespawn(class_3222 var1, class_3222 var2, boolean var3);
    }

    @FunctionalInterface
    public static interface CopyFrom {
        public void copyFromPlayer(class_3222 var1, class_3222 var2, boolean var3);
    }
}

